package gov.va.med.mhv.rxrefill.data.model;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="RX_TRACKING_EMAIL_NOTIF_STATUS")
public class RxTrackingEmailNotificationStatus {
	
	@Id
	@Column(name="RX_TRACKING_EMAIL_NOTIF_ID")
	@GeneratedValue(strategy=GenerationType.AUTO)
	private Long id;
	
	@Column(name="USER_PROFILE_ID")
	private Long userprofileId;
	
	@Column(name="STATION_NUMBER")
	private String stationNumber;
	
	@Column(name="PRESCRIPTION_NUMBER")
	private String prescriptionNumber;
	
	@Column(name="TRACKING_INFORMATION")
	private String trackingInformation;
	
	@Column(name="STATUS")
	private String status;
	
	
	@Column(name="CREATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdDate;
	
	@Column(name="MODIFIED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date modifiedDate;
	
	@Column(name="OPLOCK")
	private Integer oplock = 0;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getUserprofileId() {
		return userprofileId;
	}

	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}

	public String getStationNumber() {
		return stationNumber;
	}

	public void setStationNumber(String stationNumber) {
		this.stationNumber = stationNumber;
	}

	public String getPrescriptionNumber() {
		return prescriptionNumber;
	}

	public void setPrescriptionNumber(String prescriptionNumber) {
		this.prescriptionNumber = prescriptionNumber;
	}

	public String getTrackingInformation() {
		return trackingInformation;
	}

	public void setTrackingInformation(String trackingInformation) {
		this.trackingInformation = trackingInformation;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}



	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}
}
